// JavaScript Document

/***************************************************************************************/
// General functions
/***************************************************************************************/

function MM_openBrWindow(theURL,winName,features){ 
		window.open(theURL,winName,features);
}
function getEditorValue(instanceName){  
  // Get the editor instance that we want to interact with.
  var oEditor = FCKeditorAPI.GetInstance( instanceName ) ;
  // Get the editor contents as XHTML.
  return oEditor.GetXHTML( true ) ;  // "true" means you want it formatted.
}
function ConfirmDelete(name)
{ return window.confirm("Do You Want To Delete "+name );}


/////////////////////////////////////////////////////////////////////////////////////////
///////////////   Checks whether a date entered is a valid date or not.  ////////////////
/////////////////////////////////////////////////////////////////////////////////////////
function checkDate(ddVal, mmVal, yyVal) {
	if(ddVal <= 0 || ddVal > 31 || mmVal <= 0 || mmVal > 12 || yyVal <= 0 || yyVal.length != 4) {
		alert("Please enter a valid date");
		return false;
	}
	monthArray = new Array("January", "Febuary", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December");
	if(mmVal == 2) {
		if(yyVal % 4 == 0) {
			if(ddVal > 29) {
				alert("February " + yyVal + " has only 29 days");
				return false;
			}
		}
		else {
			if(ddVal > 28) {
				alert("February " + yyVal + " has only 28 days");
				return false;
			}
		}
	}
	else {
		if(mmVal == 4 || mmVal == 6 || mmVal == 9 || mmVal == 11) {
			if(ddVal > 30) {
				alert(monthArray[mmVal-1] + " has only 30 days");
				return false;
			}
		}
	}
	return true;
}

/////////////////////////////////////////////////////////////////////////////////////////
// Checks whether a string is a valid email address.
/////////////////////////////////////////////////////////////////////////////////////////
function checkEmail(emailString) {
	splitVal = emailString.split('@');
	
	if(splitVal.length <= 1) {
		alert("Please enter a valid email address");
		return false;
	}
	if(splitVal[0].length <= 0 || splitVal[1].length <= 0) {
		alert("Please enter a valid email address");
		return false;
	}
	
	splitDomain = splitVal[1].split('.');
	if(splitDomain.length <= 1) {
		alert("Please enter a valid email address");
		return false;
	}
	if(splitDomain[0].length <= 0 || splitDomain[1].length <= 1) {
		alert("Please enter a valid email address");
		return false;
	}
	return true;
}

/////////////////////////////////////////////////////////////////////////////////////////
// Removes the leading and trailing spaces in a strings and returns the trimmed string //
/////////////////////////////////////////////////////////////////////////////////////////
function trimSpaces(stringValue) {
	// Checks the first occurance of spaces and removes them
	for(i = 0; i < stringValue.length; i++) {
		if(stringValue.charAt(i) != " ") {
			break;
		}
	}
	if(i > 0) {
		stringValue = stringValue.substring(i);
	}
	
	// Checks the last occurance of spaces and removes them
	strLength = stringValue.length - 1;
	for(i = strLength; i >= 0; i--) {
		if(stringValue.charAt(i) != " ") {
			break;
		}
	}
	if(i < strLength) {
		stringValue = stringValue.substring(0, i + 1);
	}
	
	// Returns the string after removing leading and trailing spaces.
	return stringValue;
}

/////////////////////////////////////////////////////////////////////////////////////////
//************* Check whether a string contain permitted characters only **************//
/////////////////////////////////////////////////////////////////////////////////////////
function checkAllowedChars(strToCheck, allowedChars)
{
     var acLen     = allowedChars.length;
     var stcLen     = strToCheck.length;
     strToCheck     = strToCheck.toLowerCase();
     var i;
     var j;
     var rightCount = 0;
     for(i = 0; i < acLen; i++)
     {
          switch(allowedChars.charAt(i))
          {
          case 'A':
               for(j = 0; j< stcLen; j++)
               {
                    rightCount += strToCheck.charAt(j) >= 'a' && strToCheck.charAt(j) <= 'z';
               }
               break;
          case 'N':
               for(j = 0; j< stcLen; j++)
               {
                    rightCount += strToCheck.charAt(j) >= '0' && strToCheck.charAt(j) <= '9';
               }
               break;
          default:
               for(j = -1; -1 != (j = strToCheck.indexOf(allowedChars.charAt(i), j + 1)); rightCount++);
               break;
          }
     }
     if(rightCount == stcLen)
     {
          return true;
     }
     return false;
}

/////////////////////////////////////////////////////////////////////////////////////////
//// Checks whether the first date argument is less than the second date argument
//// Date arguments should be in the format - dd/mm/yyyy
/////////////////////////////////////////////////////////////////////////////////////////
function checkDateDifference(lowDate, highDate, comparison) {
	lowDateSplit = lowDate.split('/');
	highDateSplit = highDate.split('/');

	date1 = new Date();
	date2 = new Date();

	date1.setDate(lowDateSplit[0]);
	date1.setMonth(lowDateSplit[1] - 1);
	date1.setYear(lowDateSplit[2]);

	date2.setDate(highDateSplit[0]);
	date2.setMonth(highDateSplit[1] - 1);
	date2.setYear(highDateSplit[2]);

	if(comparison == "eq") {
		if(date1.getTime() == date2.getTime()) {
			return true;
		}
		else {
			return false;
		}
	}
	else if(comparison == "lt") {
		if(date1.getTime() < date2.getTime()) {
			return true;
		}
		else {
			return false;
		}
	}
	else if(comparison == "gt") {
		if(date1.getTime() > date2.getTime()) {
			return true;
		}
		else {
			return false;
		}
	}
	else if(comparison == "le") {
		if(date1.getTime() <= date2.getTime()) {
			return true;
		}
		else {
			return false;
		}
	}
	else if(comparison == "ge") {
		if(date1.getTime() >= date2.getTime()) {
			return true;
		}
		else {
			return false;
		}
	}
}

function formatCheck(dateStr) {
	dateSplit = dateStr.split("/");
	if(dateSplit.length != 3) {
		return false;
	}
	if(trimSpaces(dateSplit[0]).length <= 0 || trimSpaces(dateSplit[1]).length <= 0 || trimSpaces(dateSplit[2]).length <= 0) {
		return false;
	}
	return true;
}
//function to open in custom window
function openWindow(url,window_name,winWidth,winHeight,fscroll,position) {
	sWidth = screen.availWidth;
	sHeight = screen.availHeight;

	if(!position || position.length <= 0) {
		sLeft = (sWidth - winWidth) / 2;
		sTop = (sHeight - winHeight) / 2;
	}else if(position == 'TL') { //Top left
		sLeft = 0;
		sTop = 0;
	}else if(position == 'TR') { //Top right
		sLeft = (sWidth - winWidth) - 30;
		sTop = 0;
	}else if(position == 'BL') { //Bottom left
		sLeft = 0;
		sTop = (sHeight - winHeight) - 50;
	}else if(position == 'BR') { //Bottom left
		sLeft = (sWidth - winWidth) - 30;
		sTop = (sHeight - winHeight) - 50;
	}

	if(fscroll == '') {fscroll = 0}
	window.open(url,window_name,"width=" + winWidth + ",height=" + winHeight + ",top=" + sTop + ",left=" + sLeft + ",toolbar=0,menubar=0,status=0,scrollbars=" + fscroll + ",resizable=0");
}
//To print Current Date in the format D-Month Name-Year
function writeDate() 
{
	var monthNames = new Array ("January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December");
	var dayNames = new Array ("Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday");
	var now = new Date();
	var amPm = (now.getHours() < 12) ? "am" : "pm";
	var hour = (now.getHours() > 12) ? (now.getHours() - 12) : (hour == 0) ? "12" : now.getHours();
	var min = (now.getMinutes() < 10) ? ("0" + now.getMinutes()) : (now.getMinutes());
	document.write (now.getDate()+" - "+monthNames[now.getMonth()] + " - " +now.getYear() );
}

function checkTimings()
{
	if(document.forms[0].timings.value=="")
	{
		alert("Please enter timing");
		document.forms[0].timings.focus();
		return false;
	}
	document.forms[0].toDo.value="add";
}

function editTiming(ndx,tim_id)
{
	if(document.forms[1].elements["elm[]"][ndx].value=="")
	{
		alert("Please enter timing");
		document.forms[1].elements["elm[]"][ndx].focus();
		return false;
	}
	document.forms[1].toDo.value="edit";
	document.forms[1].tim_id.value= tim_id;
	document.forms[1].tim_val.value = document.forms[1].elements["elm[]"][ndx].value;
}

function delTiming(tim_id)
{
	if(confirm("Are you sure you want to delete the selected record?"))
	{
		document.forms[1].toDo.value="delete";
		document.forms[1].tim_id.value= tim_id;	
	}
	else return false;
}

function addRooms()
{
	if(trimSpaces(document.forms[0].rname.value)=="")
	{
		alert("Please enter Name of Room");
		document.forms[0].rname.focus();
		return false;	
	}
	tot= document.forms[0].tot.value;
	availNdx = 3;
	noRooms = true;
	for(x=0;x<tot;x++)
	{
		rateNdx = availNdx - 2;
		taxNdx = availNdx - 1;
		if(document.forms[0].elements[availNdx].checked)
		{
			noRooms = false;
			if(document.forms[0].elements[rateNdx].value=="")
			{
				alert("Please enter Rate");
				document.forms[0].elements[rateNdx].focus();
				return false;
			}
			if(document.forms[0].elements[taxNdx].value=="")
			{
				alert("Please enter Tax");
				document.forms[0].elements[taxNdx].focus();
				return false;
			}
			availNdx = availNdx + 3;
		}
	}
	if(noRooms)
	{
		alert("Please select at least one Room type and enter Rate and Tax");
		return false;
	}
//from date validation	
dd = document.forms[0].from_day.options[document.forms[0].from_day.selectedIndex].value;
mm = document.forms[0].from_month.options[document.forms[0].from_month.selectedIndex].value;
yy = document.forms[0].from_year.options[document.forms[0].from_year.selectedIndex].value;
if (!checkDate(dd,mm,yy))
return false;

	var tDate = new Date();
	if (mm.length < 2) mm = "0" + mm;
	if (dd.length < 2) dd = "0" + dd;
	sDate = yy + mm + dd;

	sMonth = (tDate.getMonth() + 1).toString();
	sDay = (tDate.getDate()).toString();
	sYear = (tDate.getFullYear()).toString();
	if (sMonth.length < 2) sMonth = "0" + sMonth;
	if (sDay.length < 2) sDay = "0" + sDay;
	sCurDate = sYear + sMonth + sDay;
	
	if (sDate < sCurDate) {
		window.alert("You cannot specify a Date prior to today.");
		document.forms[0].focus();
		return false;
	}
	fromDate = sDate
	
//to date validation
dd = document.forms[0].to_day.options[document.forms[0].to_day.selectedIndex].value;
mm = document.forms[0].to_month.options[document.forms[0].to_month.selectedIndex].value;
yy = document.forms[0].to_year.options[document.forms[0].to_year.selectedIndex].value;
if (!checkDate(dd,mm,yy))
return false;

	var tDate = new Date();
	if (mm.length < 2) mm = "0" + mm;
	if (dd.length < 2) dd = "0" + dd;
	sDate = yy + mm + dd;

	sMonth = (tDate.getMonth() + 1).toString();
	sDay = (tDate.getDate()).toString();
	sYear = (tDate.getFullYear()).toString();
	if (sMonth.length < 2) sMonth = "0" + sMonth;
	if (sDay.length < 2) sDay = "0" + sDay;
	sCurDate = sYear + sMonth + sDay;
	
	if (sDate < sCurDate) {
		window.alert("You cannot specify a Date prior to today.");
		document.forms[0].focus();
		return false;
	}

	if (sDate < fromDate) {
		window.alert("You cannot specify a Date prior to From Date.");
		document.forms[0].focus();
		return false;
	}
	document.forms[0].frmAction.value="insert";

}

function addMap()
{
	if(trimSpaces(document.forms[0].map.value)=="")
	{
		alert("Please Select map image to upload");
		document.forms[0].map.focus();
		return false;	
	}
	document.forms[0].frmAction.value="update";
}
function delMap()
{
	if(confirm("Are you sure you want to delete the location map?"))
	{
		document.forms[0].frmAction.value="delete";
		document.forms[0].submit();
	}
}
function addPalette()
{
	if(trimSpaces(document.forms[0].map.value)=="")
	{
		alert("Please Select image to upload");
		document.forms[0].map.focus();
		return false;	
	}
	document.forms[0].frmAction.value="update";
}
function delPalette()
{
	if(confirm("Are you sure you want to delete the colour palette?"))
	{
		document.forms[0].frmAction.value="delete";
		document.forms[0].submit();
	}
}
function checkSearch(){

	if(trimSpaces(document.frmSearch.txtKey.value)==""){
		alert("Please enter  keyword");
		document.frmSearch.txtKey.focus();
		return false;
	}
		
}
function chkReq_survey()
{
	if(document.frmSurvey.sb_company.value==""){
		alert("Please Enter Company.");
		document.frmSurvey.sb_company.focus();
		return false;
	}
	if(document.frmSurvey.sb_name.value==""){
		alert("Please Enter Name.");
		document.frmSurvey.sb_name.focus();
		return false;
	}
	if(!checkEmail(document.frmSurvey.sb_email.value))
	{
		document.frmSurvey.sb_email.select();
		return false;
	}
	if(document.frmSurvey.sb_phone.value=="")
	{	
		alert("Please Enter Phone Number.");
		document.frmSurvey.sb_phone.focus();
		return false;
	}
}
	function checkSearch(frm)
	{
	if(frm.txtKey.value=="")
	{
	alert("Please enter search key!");
	frm.txtKey.focus();
	return false;
	}
	}

/**********************************************************/
//Simple Image Trail script- By JavaScriptKit.com
//Visit http://www.javascriptkit.com for this script and more
//This notice must stay intact
/**********************************************************/

var offsetfrommouse=[15,25]; //image x,y offsets from cursor position in pixels. Enter 0,0 for no offset
var displayduration=0; //duration in seconds image should remain visible. 0 for always.

var defaultimageheight = 40;	// maximum image size.
var defaultimagewidth = 40;	// maximum image size.

var timer;

function gettrailobj(){
if (document.getElementById)
return document.getElementById("preview_div").style
}

function gettrailobjnostyle(){
if (document.getElementById)
return document.getElementById("preview_div")
}


function truebody(){
return (!window.opera && document.compatMode && document.compatMode!="BackCompat")? document.documentElement : document.body
}


function hidetrail(){	
	gettrailobj().display= "none";
	document.onmousemove=""
	gettrailobj().left="-500px"
	clearTimeout(timer);
}

function showtrail(imagename,title,width,height){
	i = imagename
	t = title
	w = width
	h = height;
	timer = setTimeout("show('"+i+"',t,w,h);",200);
}
function show(imagename,title,width,height){
 
    var docwidth=document.all? truebody().scrollLeft+truebody().clientWidth : pageXOffset+window.innerWidth - offsetfrommouse[0]
	var docheight=document.all? Math.min(truebody().scrollHeight, truebody().clientHeight) : Math.min(window.innerHeight)

	if( (navigator.userAgent.indexOf("Konqueror")==-1  || navigator.userAgent.indexOf("Firefox")!=-1 || (navigator.userAgent.indexOf("Opera")==-1 && navigator.appVersion.indexOf("MSIE")!=-1)) && (docwidth>650 && docheight>500)) {
		( width == 0 ) ? width = defaultimagewidth : '';
		( height == 0 ) ? height = defaultimageheight : '';
			
		width+=20;
		height+=50;
		defaultimageheight = height
		defaultimagewidth = width
	
		document.onmousemove=followmouse; 

		
		newHTML = '<div aligh="center" class="border_preview" style="width:'+  width +'px;height:'+ height +'px"><div id="loader_container" aligh="center"><div id="loader"><div align="center">Loading Image...</div><div id="loader_bg"><div id="progress"> </div></div></div></div>';
		newHTML = newHTML + '<h3 class="title_h2" aligh="center">'+title+'</h2>';
		
    	newHTML = newHTML + '<div aligh="center" class="preview_temp_load"><img onload="javascript:remove_loading();" src="' + imagename + '" border="0"></div>';
		newHTML = newHTML + '</div>'; 
		
		if(navigator.userAgent.indexOf("MSIE")!=-1 && navigator.userAgent.indexOf("Opera")==-1 ){
			newHTML = newHTML+'<iframe src="about:blank" scrolling="no" frameborder="0" width="'+width+'" height="'+height+'"></iframe>';
		}		

		gettrailobjnostyle().innerHTML = newHTML; 
		gettrailobj().display="block";
	}
}

function followmouse(e){

	var xcoord=offsetfrommouse[0]
	var ycoord=offsetfrommouse[1]

	var docwidth=document.all? truebody().scrollLeft+truebody().clientWidth : pageXOffset+window.innerWidth-15
	var docheight=document.all? Math.min(truebody().scrollHeight, truebody().clientHeight) : Math.min(window.innerHeight)

	if (typeof e != "undefined"){
		if (docwidth - e.pageX < defaultimagewidth + 2*offsetfrommouse[0]){
			xcoord = e.pageX - xcoord - defaultimagewidth; // Move to the left side of the cursor
		} else {
			xcoord += e.pageX;
		}
		if (docheight - e.pageY < defaultimageheight + 2*offsetfrommouse[1]){
			ycoord += e.pageY - Math.max(0,(2*offsetfrommouse[1] + defaultimageheight + e.pageY - docheight - truebody().scrollTop));
		} else {
			ycoord += e.pageY;
		}

	} else if (typeof window.event != "undefined"){
		if (docwidth - event.clientX < defaultimagewidth + 2*offsetfrommouse[0]){
			xcoord = event.clientX + truebody().scrollLeft - xcoord - defaultimagewidth; // Move to the left side of the cursor
		} else {
			xcoord += truebody().scrollLeft+event.clientX
		}
		if (docheight - event.clientY < (defaultimageheight + 2*offsetfrommouse[1])){
			ycoord += event.clientY + truebody().scrollTop - Math.max(0,(2*offsetfrommouse[1] + defaultimageheight + event.clientY - docheight));
		} else {
			ycoord += truebody().scrollTop + event.clientY;
		}
	}
	gettrailobj().left=xcoord+"px"
	gettrailobj().top=ycoord+"px"

}
 
var t_id = setInterval(animate,20);
var pos=0;
var dir=2;
var len=0;

		function animate()
		{	var elem = document.getElementById('progress');
			if(elem != null) 
			{	if (pos==0) len += dir;
				if (len>32 || pos>79) pos += dir;
				if (pos>79) len -= dir;
				if (pos>79 && len==0) pos=0;
				elem.style.left = pos;
				elem.style.width = len;
			}
		}

function remove_loading() 
{	this.clearInterval(t_id);
	var targelem = document.getElementById('loader_container');
	targelem.style.display='none';
	targelem.style.visibility='hidden';
	var t_id = setInterval(animate,60);
}

/************************* DATE PICKER STARTS ************************************/
/**
This is a JavaScript library that will allow you to easily add some basic DHTML
drop-down datepicker functionality to your Notes forms. This script is not as
full-featured as others you may find on the Internet, but it's free, it's easy to
understand, and it's easy to change.

You'll also want to include a stylesheet that makes the datepicker elements
look nice. An example one can be found in the database that this script was
originally released with, at:

http://www.nsftools.com/tips/NotesTips.htm#datepicker

I've tested this lightly with Internet Explorer 6 and Mozilla Firefox. I have no idea
how compatible it is with other browsers.

version 1.5
December 4, 2005
Julian Robichaux -- http://www.nsftools.com

HISTORY
--  version 1.0 (Sept. 4, 2004):
Initial release.

--  version 1.1 (Sept. 5, 2004):
Added capability to define the date format to be used, either globally (using the
defaultDateSeparator and defaultDateFormat variables) or when the displayDatePicker
function is called.

--  version 1.2 (Sept. 7, 2004):
Fixed problem where datepicker x-y coordinates weren't right inside of a table.
Fixed problem where datepicker wouldn't display over selection lists on a page.
Added a call to the datePickerClosed function (if one exists) after the datepicker
is closed, to allow the developer to add their own custom validation after a date
has been chosen. For this to work, you must have a function called datePickerClosed
somewhere on the page, that accepts a field object as a parameter. See the
example in the comments of the updateDateField function for more details.

--  version 1.3 (Sept. 9, 2004)
Fixed problem where adding the <div> and <iFrame> used for displaying the datepicker
was causing problems on IE 6 with global variables that had handles to objects on
the page (I fixed the problem by adding the elements using document.createElement()
and document.body.appendChild() instead of document.body.innerHTML += ...).

--  version 1.4 (Dec. 20, 2004)
Added "targetDateField.focus();" to the updateDateField function (as suggested
by Alan Lepofsky) to avoid a situation where the cursor focus is at the top of the
form after a date has been picked. Added "padding: 0px;" to the dpButton CSS
style, to keep the table from being so wide when displayed in Firefox.

-- version 1.5 (Dec 4, 2005)
Added display=none when datepicker is hidden, to fix problem where cursor is
not visible on input fields that are beneath the date picker. Added additional null
date handling for date errors in Safari when the date is empty. Added additional
error handling for iFrame creation, to avoid reported errors in Opera. Added
onMouseOver event for day cells, to allow color changes when the mouse hovers
over a cell (to make it easier to determine what cell you're over). Added comments
in the style sheet, to make it more clear what the different style elements are for.
*/

var datePickerDivID = "datepicker";
var iFrameDivID = "datepickeriframe";

var dayArrayShort = new Array('Su', 'Mo', 'Tu', 'We', 'Th', 'Fr', 'Sa');
var dayArrayMed = new Array('Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat');
var dayArrayLong = new Array('Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday');
var monthArrayShort = new Array('Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec');
var monthArrayMed = new Array('Jan', 'Feb', 'Mar', 'Apr', 'May', 'June', 'July', 'Aug', 'Sept', 'Oct', 'Nov', 'Dec');
var monthArrayLong = new Array('January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December');
 
// these variables define the date formatting we're expecting and outputting.
// If you want to use a different format by default, change the defaultDateSeparator
// and defaultDateFormat variables either here or on your HTML page.
var defaultDateSeparator = "-";        // common values would be "/" or "."
var defaultDateFormat = "mdy"    // valid values are "mdy", "dmy", and "ymd"
var dateSeparator = defaultDateSeparator;
var dateFormat = defaultDateFormat;

/**
This is the main function you'll call from the onClick event of a button.
Normally, you'll have something like this on your HTML page:

Start Date: <input name="StartDate">
<input type=button value="select" onclick="displayDatePicker('StartDate');">

That will cause the datepicker to be displayed beneath the StartDate field and
any date that is chosen will update the value of that field. If you'd rather have the
datepicker display beneath the button that was clicked, you can code the button
like this:

<input type=button value="select" onclick="displayDatePicker('StartDate', this);">

So, pretty much, the first argument (dateFieldName) is a string representing the
name of the field that will be modified if the user picks a date, and the second
argument (displayBelowThisObject) is optional and represents an actual node
on the HTML document that the datepicker should be displayed below.

In version 1.1 of this code, the dtFormat and dtSep variables were added, allowing
you to use a specific date format or date separator for a given call to this function.
Normally, you'll just want to set these defaults globally with the defaultDateSeparator
and defaultDateFormat variables, but it doesn't hurt anything to add them as optional
parameters here. An example of use is:

<input type=button value="select" onclick="displayDatePicker('StartDate', false, 'dmy', '.');">

This would display the datepicker beneath the StartDate field (because the
displayBelowThisObject parameter was false), and update the StartDate field with
the chosen value of the datepicker using a date format of dd.mm.yyyy
*/
function displayDatePicker(dateFieldName, displayBelowThisObject, dtFormat, dtSep)
{
  var targetDateField = document.getElementsByName (dateFieldName).item(0);
 
  // if we weren't told what node to display the datepicker beneath, just display it
  // beneath the date field we're updating
  if (!displayBelowThisObject)
    displayBelowThisObject = targetDateField;
 
  // if a date separator character was given, update the dateSeparator variable
  if (dtSep)
    dateSeparator = dtSep;
  else
    dateSeparator = defaultDateSeparator;
 
  // if a date format was given, update the dateFormat variable
  if (dtFormat)
    dateFormat = dtFormat;
  else
    dateFormat = defaultDateFormat;
 
  var x = displayBelowThisObject.offsetLeft;
  var y = displayBelowThisObject.offsetTop + displayBelowThisObject.offsetHeight ;
 
  // deal with elements inside tables and such
  var parent = displayBelowThisObject;
  while (parent.offsetParent) {
    parent = parent.offsetParent;
    x += parent.offsetLeft;
    y += parent.offsetTop ;
  }
 
  drawDatePicker(targetDateField, x, y);
}


/**
Draw the datepicker object (which is just a table with calendar elements) at the
specified x and y coordinates, using the targetDateField object as the input tag
that will ultimately be populated with a date.

This function will normally be called by the displayDatePicker function.
*/
function drawDatePicker(targetDateField, x, y)
{
  var dt = getFieldDate(targetDateField.value );
 
  // the datepicker table will be drawn inside of a <div> with an ID defined by the
  // global datePickerDivID variable. If such a div doesn't yet exist on the HTML
  // document we're working with, add one.
  if (!document.getElementById(datePickerDivID)) {
    // don't use innerHTML to update the body, because it can cause global variables
    // that are currently pointing to objects on the page to have bad references
    //document.body.innerHTML += "<div id='" + datePickerDivID + "' class='dpDiv'></div>";
    var newNode = document.createElement("div");
    newNode.setAttribute("id", datePickerDivID);
    newNode.setAttribute("class", "dpDiv");
    newNode.setAttribute("style", "visibility: hidden;");
    document.body.appendChild(newNode);
  }
 
  // move the datepicker div to the proper x,y coordinate and toggle the visiblity
  var pickerDiv = document.getElementById(datePickerDivID);
  pickerDiv.style.position = "absolute";
  pickerDiv.style.left = x + "px";
  pickerDiv.style.top = y + "px";
  pickerDiv.style.visibility = (pickerDiv.style.visibility == "visible" ? "hidden" : "visible");
  pickerDiv.style.display = (pickerDiv.style.display == "block" ? "none" : "block");
  pickerDiv.style.zIndex = 10000;
 
  // draw the datepicker table
  refreshDatePicker(targetDateField.name, dt.getFullYear(), dt.getMonth(), dt.getDate());
}


/**
This is the function that actually draws the datepicker calendar.
*/
function refreshDatePicker(dateFieldName, year, month, day)
{
  // if no arguments are passed, use today's date; otherwise, month and year
  // are required (if a day is passed, it will be highlighted later)
  var thisDay = new Date();
 
  if ((month >= 0) && (year > 0)) {
    thisDay = new Date(year, month, 1);
  } else {
    day = thisDay.getDate();
    thisDay.setDate(1);
  }
 
  // the calendar will be drawn as a table
  // you can customize the table elements with a global CSS style sheet,
  // or by hardcoding style and formatting elements below
  var crlf = "\r\n";
  var TABLE = "<table cols=7 cellpadding=3 class='dpTable'>" + crlf;
  var xTABLE = "</table>" + crlf;
  var TR = "<tr class='dpTR'>";
  var TR_title = "<tr class='dpTitleTR'>";
  var TR_days = "<tr class='dpDayTR'>";
  var TR_todaybutton = "<tr class='dpTodayButtonTR'>";
  var xTR = "</tr>" + crlf;
  var TD = "<td class='dpTD' onMouseOut='this.className=\"dpTD\";' onMouseOver=' this.className=\"dpTDHover\";' ";    // leave this tag open, because we'll be adding an onClick event
  var TD_title = "<td colspan=5 class='dpTitleTD'>";
  var TD_buttons = "<td class='dpButtonTD'>";
  var TD_todaybutton = "<td colspan=7 class='dpTodayButtonTD'>";
  var TD_days = "<td class='dpDayTD'>";
  var TD_selected = "<td class='dpDayHighlightTD' onMouseOut='this.className=\"dpDayHighlightTD\";' onMouseOver='this.className=\"dpTDHover\";' ";    // leave this tag open, because we'll be adding an onClick event
  var xTD = "</td>" + crlf;
  var DIV_title = "<div class='dpTitleText'>";
  var DIV_selected = "<div class='dpDayHighlight'>";
  var xDIV = "</div>";
 
  // start generating the code for the calendar table
  var html = TABLE;
 
  // this is the title bar, which displays the month and the buttons to
  // go back to a previous month or forward to the next month
  html += TR_title;
  html += TD_buttons + getButtonCode(dateFieldName, thisDay, -1, "&lt;") + xTD;
  html += TD_title + DIV_title + monthArrayLong[ thisDay.getMonth()] + " " + thisDay.getFullYear() + xDIV + xTD;
  html += TD_buttons + getButtonCode(dateFieldName, thisDay, 1, "&gt;") + xTD;
  html += xTR;
 
  // this is the row that indicates which day of the week we're on
  html += TR_days;
  for(i = 0; i < dayArrayShort.length; i++)
    html += TD_days + dayArrayShort[i] + xTD;
  html += xTR;
 
  // now we'll start populating the table with days of the month
  html += TR;
 
  // first, the leading blanks
  for (i = 0; i < thisDay.getDay(); i++)
    html += TD + "&nbsp;" + xTD;
 
  // now, the days of the month
  do {
    dayNum = thisDay.getDate();
    TD_onclick = " onclick=\"updateDateField('" + dateFieldName + "', '" + getDateString(thisDay) + "');\">";
    
    if (dayNum == day)
      html += TD_selected + TD_onclick + DIV_selected + dayNum + xDIV + xTD;
    else
      html += TD + TD_onclick + dayNum + xTD;
    
    // if this is a Saturday, start a new row
    if (thisDay.getDay() == 6)
      html += xTR + TR;
    
    // increment the day
    thisDay.setDate(thisDay.getDate() + 1);
  } while (thisDay.getDate() > 1)
 
  // fill in any trailing blanks
  if (thisDay.getDay() > 0) {
    for (i = 6; i > thisDay.getDay(); i--)
      html += TD + "&nbsp;" + xTD;
  }
  html += xTR;
 
  // add a button to allow the user to easily return to today, or close the calendar
  var today = new Date();
  var todayString = "Today is " + dayArrayMed[today.getDay()] + ", " + monthArrayMed[ today.getMonth()] + " " + today.getDate();
  html += TR_todaybutton + TD_todaybutton;
  html += "<button class='dpTodayButton' onClick='refreshDatePicker(\"" + dateFieldName + "\");'>this month</button> ";
  html += "<button class='dpTodayButton' onClick='updateDateField(\"" + dateFieldName + "\");'>close</button>";
  html += xTD + xTR;
 
  // and finally, close the table
  html += xTABLE;
 
  document.getElementById(datePickerDivID).innerHTML = html;
  // add an "iFrame shim" to allow the datepicker to display above selection lists
  adjustiFrame();
}


/**
Convenience function for writing the code for the buttons that bring us back or forward
a month.
*/
function getButtonCode(dateFieldName, dateVal, adjust, label)
{
  var newMonth = (dateVal.getMonth () + adjust) % 12;
  var newYear = dateVal.getFullYear() + parseInt((dateVal.getMonth() + adjust) / 12);
  if (newMonth < 0) {
    newMonth += 12;
    newYear += -1;
  }
 
  return "<button class='dpButton' onClick='refreshDatePicker(\"" + dateFieldName + "\", " + newYear + ", " + newMonth + ");'>" + label + "</button>";
}


/**
Convert a JavaScript Date object to a string, based on the dateFormat and dateSeparator
variables at the beginning of this script library.
*/
function getDateString(dateVal)
{
  var dayString = "00" + dateVal.getDate();
  var monthString = "00" + (dateVal.getMonth()+1);
  dayString = dayString.substring(dayString.length - 2);
  monthString = monthString.substring(monthString.length - 2);
 
  switch (dateFormat) {
    case "dmy" :
      return dayString + dateSeparator + monthString + dateSeparator + dateVal.getFullYear();
    case "ymd" :
      return dateVal.getFullYear() + dateSeparator + monthString + dateSeparator + dayString;
    case "mdy" :
    default :
      return monthString + dateSeparator + dayString + dateSeparator + dateVal.getFullYear();
  }
}


/**
Convert a string to a JavaScript Date object.
*/
function getFieldDate(dateString)
{
  var dateVal;
  var dArray;
  var d, m, y;
 
  try {
    dArray = splitDateString(dateString);
    if (dArray) {
      switch (dateFormat) {
        case "dmy" :
          d = parseInt(dArray[0], 10);
          m = parseInt(dArray[1], 10) - 1;
          y = parseInt(dArray[2], 10);
          break;
        case "ymd" :
          d = parseInt(dArray[2], 10);
          m = parseInt(dArray[1], 10) - 1;
          y = parseInt(dArray[0], 10);
          break;
        case "mdy" :
        default :
          d = parseInt(dArray[1], 10);
          m = parseInt(dArray[0], 10) - 1;
          y = parseInt(dArray[2], 10);
          break;
      }
      dateVal = new Date(y, m, d);
    } else if (dateString) {
      dateVal = new Date(dateString);
    } else {
      dateVal = new Date();
    }
  } catch(e) {
    dateVal = new Date();
  }
 
  return dateVal;
}


/**
Try to split a date string into an array of elements, using common date separators.
If the date is split, an array is returned; otherwise, we just return false.
*/
function splitDateString(dateString)
{
  var dArray;
  if (dateString.indexOf("/") >= 0)
    dArray = dateString.split("/");
  else if (dateString.indexOf(".") >= 0)
    dArray = dateString.split(".");
  else if (dateString.indexOf("-") >= 0)
    dArray = dateString.split("-");
  else if (dateString.indexOf("\\") >= 0)
    dArray = dateString.split("\\");
  else
    dArray = false;
 
  return dArray;
}

/**
Update the field with the given dateFieldName with the dateString that has been passed,
and hide the datepicker. If no dateString is passed, just close the datepicker without
changing the field value.

Also, if the page developer has defined a function called datePickerClosed anywhere on
the page or in an imported library, we will attempt to run that function with the updated
field as a parameter. This can be used for such things as date validation, setting default
values for related fields, etc. For example, you might have a function like this to validate
a start date field:

function datePickerClosed(dateField)
{
  var dateObj = getFieldDate(dateField.value);
  var today = new Date();
  today = new Date(today.getFullYear(), today.getMonth(), today.getDate());
 
  if (dateField.name == "StartDate") {
    if (dateObj < today) {
      // if the date is before today, alert the user and display the datepicker again
      alert("Please enter a date that is today or later");
      dateField.value = "";
      document.getElementById(datePickerDivID).style.visibility = "visible";
      adjustiFrame();
    } else {
      // if the date is okay, set the EndDate field to 7 days after the StartDate
      dateObj.setTime(dateObj.getTime() + (7 * 24 * 60 * 60 * 1000));
      var endDateField = document.getElementsByName ("EndDate").item(0);
      endDateField.value = getDateString(dateObj);
    }
  }
}

*/
function updateDateField(dateFieldName, dateString)
{
  var targetDateField = document.getElementsByName (dateFieldName).item(0);
  if (dateString)
    targetDateField.value = dateString;
 
  var pickerDiv = document.getElementById(datePickerDivID);
  pickerDiv.style.visibility = "hidden";
  pickerDiv.style.display = "none";
 
  adjustiFrame();
  targetDateField.focus();
 
  // after the datepicker has closed, optionally run a user-defined function called
  // datePickerClosed, passing the field that was just updated as a parameter
  // (note that this will only run if the user actually selected a date from the datepicker)
  if ((dateString) && (typeof(datePickerClosed) == "function"))
    datePickerClosed(targetDateField);
}


/**
Use an "iFrame shim" to deal with problems where the datepicker shows up behind
selection list elements, if they're below the datepicker. The problem and solution are
described at:

http://dotnetjunkies.com/WebLog/jking/archive/2003/07/21/488.aspx
http://dotnetjunkies.com/WebLog/jking/archive/2003/10/30/2975.aspx
*/
function adjustiFrame(pickerDiv, iFrameDiv)
{
  // we know that Opera doesn't like something about this, so if we
  // think we're using Opera, don't even try
  var is_opera = (navigator.userAgent.toLowerCase().indexOf("opera") != -1);
  if (is_opera)
    return;
  
  // put a try/catch block around the whole thing, just in case
  try {
    if (!document.getElementById(iFrameDivID)) {
      // don't use innerHTML to update the body, because it can cause global variables
      // that are currently pointing to objects on the page to have bad references
      //document.body.innerHTML += "<iframe id='" + iFrameDivID + "' src='javascript:false;' scrolling='no' frameborder='0'>";
      var newNode = document.createElement("iFrame");
      newNode.setAttribute("id", iFrameDivID);
      newNode.setAttribute("src", "javascript:false;");
      newNode.setAttribute("scrolling", "no");
      newNode.setAttribute ("frameborder", "0");
      document.body.appendChild(newNode);
    }
    
    if (!pickerDiv)
      pickerDiv = document.getElementById(datePickerDivID);
    if (!iFrameDiv)
      iFrameDiv = document.getElementById(iFrameDivID);
    
    try {
      iFrameDiv.style.position = "absolute";
      iFrameDiv.style.width = pickerDiv.offsetWidth;
      iFrameDiv.style.height = pickerDiv.offsetHeight ;
      iFrameDiv.style.top = pickerDiv.style.top;
      iFrameDiv.style.left = pickerDiv.style.left;
      iFrameDiv.style.zIndex = pickerDiv.style.zIndex - 1;
      iFrameDiv.style.visibility = pickerDiv.style.visibility ;
      iFrameDiv.style.display = pickerDiv.style.display;
    } catch(e) {
    }
 
  } catch (ee) {
  }
 
}
/********************************* DATE PICKER ENDS ***********************************/
